/*---------------------------------------------------------------------------*\

    FILE....: RINGSTAT.CPP
    TYPE....: C++ Console program
    AUTHOR..: David Rowe
    DATE....: 10/7/02

    OpenSwitch12 test program - rings port while port is on hook, stops
    ringing when port goes off hook and plays a 10sec dialtone.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>
#include "kbhit.h"

#include "../src/vpbapi.h"
#include "../src/verbose.h"

#define ON_HOOK  0
#define OFF_HOOK 1

#define CH 12

VPB_TONE DialTone     = {450, 425, 400, -10,   -10,  -10, 10000, 0   };

int arg_exists(int argc, char *argv[], char *arg);

int main(int argc, char * argv[])
{
	int	        h[CH], ret, state[CH], next_state, i;
	VPB_EVENT	e;
	char		s[VPB_MAX_STR];

	verbose(1);
	for(i=0; i<CH; i++) {
		h[i] = vpb_open(1,i+1);
		vpb_disable_event(h[i], VPB_MRING);
		vpb_ring_station_sync(h[i], VPB_RING_STATION_ON);
		state[i] = ON_HOOK;
	}

	do {
		ret = vpb_get_event_async(&e);
		if (ret == VPB_OK) {
			vpb_translate_event(&e, s);
			printf("%s",s);
			
			next_state = state[e.handle];
			switch(state[e.handle]) {
			case ON_HOOK:
				if (e.type == VPB_STATION_OFFHOOK) {
					vpb_playtone_async(e.handle,
							   &DialTone);	
					next_state = OFF_HOOK;
				}
				break;
			case OFF_HOOK:
				if (e.type == VPB_STATION_ONHOOK) {
					vpb_tone_terminate(e.handle);
					vpb_ring_station_sync(
                                           e.handle, VPB_RING_STATION_ON);
					next_state = ON_HOOK;
				}
				break;
			}

			state[e.handle] = next_state;
					
		}
		vpb_sleep(10);

	} while(!kbhit());

	for(i=0; i<CH; i++) {
		vpb_ring_station_sync(h[i], VPB_RING_STATION_OFF);
	}
	vpb_sleep(2000);
	for(i=0; i<CH; i++) {
		vpb_close(h[i]);
	}

	return 0;
}

int arg_exists(int argc, char *argv[], char *arg) {
  int i;

  for(i=0; i<argc; i++)
    if (strcmp(argv[i],arg) == 0)
      return i;

  return 0;
}








